#include "Resolver.h"
#include "TalonFiveGameRegistry.h"
#include "TalonFiveModule.h"
#include "TalonFiveGameInputMapping.h"
#include "TalonFiveMenuInputMapping.h"
#include "Settings.h"
#include "SettingsGetValueT.h"
#include "TalonFiveConstants.h"
#include "InputObject.h"
#include "ModuleManager.h"
#include "GlfwSharedObject.h"

#include "Game/ISyncNetworkSubProcess.h"
#include "Game/IPrepareInputSubProcess.h"
#include "Game/IInputSubProcess.h"
#include "Game/IRunLogicSubProcess.h"
#include "Game/IStartRenderingSubProcess.h"
#include "Game/IRenderSubProcess.h"
#include "Game/IFinishRenderingSubProcess.h"

#include "Game/PrepareInputSubProcess.h"
#include "Game/ModuleSubProcessStack.h"
#include "GlfwSubProcessStack.h"

using namespace basecode::Game;

namespace TalonFive {

	basecode::System::IResolvable * GameRegistry::GetInputObject(){return new basecode::Input::InputObject(0);}
	basecode::System::IResolvable * GameRegistry::GetGameInputMapping(){return new GameInputMapping();}
	basecode::System::IResolvable * GameRegistry::GetMenuInputMapping(){return new MenuInputMapping();}
	
	basecode::System::IResolvable * GameRegistry::GetSettings(){return new basecode::System::Settings();}
	basecode::System::IResolvable * GameRegistry::GetModuleManager(){return new ModuleManager();}	
	basecode::System::IResolvable * GameRegistry::GetGlfwSharedObject(){return new SharedObject();}

	//basecode::System::IResolvable * GameRegistry::GetSyncNetworkSubProcess(){return new	basecode::Game::AsioSyncNetworkSubProcess();}
	basecode::System::IResolvable * GameRegistry::GetPrepareInputSubProcess(){return new PrepareInputSubProcess();}
	basecode::System::IResolvable * GameRegistry::GetInputSubProcess(){return new ModuleHandleInputSubProcess(basecode::System::Resolve<ModuleManager>());}
	
	basecode::System::IResolvable * GameRegistry::GetRunLogicSubProcess(){return new ModuleRunLogicSubProcess(basecode::System::Resolve<ModuleManager>());}
	basecode::System::IResolvable * GameRegistry::GetStartRenderingSubProcess(){return new GlfwStartRenderingSubProcess();}
	basecode::System::IResolvable * GameRegistry::GetRenderSubProcess(){return new ModuleRenderSubProcess(basecode::System::Resolve<ModuleManager>());}
	
	basecode::System::IResolvable * GameRegistry::GetFinishRenderingSubProcess(){return new GlfwFinishRenderingSubProcess();}
	basecode::System::IResolvable * GameRegistry::GetRenderInitSubProcess(){return new GlfwInitSubProcess();}
	basecode::System::IResolvable * GameRegistry::GetRenderShutdownSubProcess(){return new GlfwShutdownSubProcess();}

	basecode::System::IResolvable * GameRegistry::GetModuleInitSubProcess(){return new ModuleInitSubProcess(basecode::System::Resolve<ModuleManager>());}
	basecode::System::IResolvable * GameRegistry::GetModuleShutdownSubProcess(){return new ModuleShutdownSubProcess(basecode::System::Resolve<ModuleManager>());}
	

	GameRegistry::~GameRegistry(){}
	void GameRegistry::AddRegistrations()
	{
		basecode::System::Register<basecode::Input::InputObject>(GameRegistry::GetInputObject).LazyShared();
		basecode::System::Register<GameInputMapping>(GameRegistry::GetGameInputMapping).LazyShared();
		basecode::System::Register<MenuInputMapping>(GameRegistry::GetMenuInputMapping).LazyShared();
		
		basecode::System::Register<basecode::System::Settings>(GameRegistry::GetSettings).Shared();
		basecode::System::Register<ModuleManager>(GameRegistry::GetModuleManager).Shared();		
		basecode::System::Register<SharedObject>(GameRegistry::GetGlfwSharedObject).LazyShared();

		//TODO: netcode!
		basecode::System::Register<IPrepareInputSubProcess>(GameRegistry::GetPrepareInputSubProcess).LazyShared();
		basecode::System::Register<IInputSubProcess>(GameRegistry::GetInputSubProcess).LazyShared();
		
		basecode::System::Register<IRunLogicSubProcess>(GameRegistry::GetRunLogicSubProcess).LazyShared();
		basecode::System::Register<IStartRenderingSubProcess>(GameRegistry::GetStartRenderingSubProcess).LazyShared();
		basecode::System::Register<IRenderSubProcess>(GameRegistry::GetRenderSubProcess).LazyShared();
		
		basecode::System::Register<IFinishRenderingSubProcess>(GameRegistry::GetFinishRenderingSubProcess).LazyShared();
		basecode::System::Register<IRenderInitSubProcess>(GameRegistry::GetRenderInitSubProcess).LazyShared();
		basecode::System::Register<IRenderShutdownSubProcess>(GameRegistry::GetRenderShutdownSubProcess).LazyShared();

		basecode::System::Register<IModuleInitSubProcess>(GameRegistry::GetModuleInitSubProcess).LazyShared();
		basecode::System::Register<IModuleShutdownSubProcess>(GameRegistry::GetModuleShutdownSubProcess).LazyShared();
	}

	void GameRegistry::RemoveRegistrations()
	{
		basecode::System::Deregister<basecode::Input::InputObject>();
		basecode::System::Deregister<GameInputMapping>();
		basecode::System::Deregister<MenuInputMapping>();
		
		basecode::System::Deregister<basecode::System::Settings>();
		basecode::System::Deregister<ModuleManager>();
		basecode::System::Deregister<SharedObject>();

		//TODO: netcode!
		basecode::System::Deregister<IPrepareInputSubProcess>();
		basecode::System::Deregister<IInputSubProcess>();
		
		basecode::System::Deregister<IRunLogicSubProcess>();
		basecode::System::Deregister<IStartRenderingSubProcess>();
		basecode::System::Deregister<IRenderSubProcess>();
		
		basecode::System::Deregister<IFinishRenderingSubProcess>();
		basecode::System::Deregister<IRenderInitSubProcess>();
		basecode::System::Deregister<IRenderShutdownSubProcess>();

		basecode::System::Deregister<IModuleInitSubProcess>();
		basecode::System::Deregister<IModuleShutdownSubProcess>();
	}

}
