#ifndef __BASECODE_SYSTEM_SETTINGS_GET_VALUE_H__
#define __BASECODE_SYSTEM_SETTINGS_GET_VALUE_H__

#include "Settings.h"

namespace basecode { namespace System {

	template <class T>
	T& GetValue(std::string key, Settings & settings) throw()
	{
		if(settings.HasValue(key)) return *((T*) settings.GetValue(key).get());
		throw error_key_not_found;
	}

	template<>
	std::string& GetValue<std::string>(std::string key, Settings & settings) throw();

	template<>
	int& GetValue<int>(std::string key, Settings & settings) throw();

	template<>
	unsigned int& GetValue<unsigned int>(std::string key, Settings & settings) throw();

	template<>
	float& GetValue<float>(std::string key, Settings & settings) throw();

	template<>
	double& GetValue<double>(std::string key, Settings & settings) throw();

	template<>
	bool& GetValue<bool>(std::string key, Settings & settings) throw();

}}

#define SET_SETTING(k,v) basecode::System::Resolve<basecode::System::Settings>()->SetValue(k, v)
#define GET_SETTING(k,t) basecode::System::GetValue<t>(k, *basecode::System::Resolve<basecode::System::Settings>())


#endif  __BASECODE_SYSTEM_SETTINGS_GET_VALUE_H__

