#ifndef __BASECODE_SYSTEM_ISETTINGS_H__
#define __BASECODE_SYSTEM_ISETTINGS_H__

#include <string>
#include <boost/unordered_map.hpp>
#include <boost/shared_ptr.hpp>

#include "IResolvable.h"
#include "SettingValue.h"
#include "Error.h"

namespace basecode { namespace System {

	class Settings : public IResolvable
	{
	private:
		boost::unordered_map<std::string, boost::shared_ptr<ICanBeASetting>> _settings;
	
	public:
		Settings();
		virtual ~Settings();

		virtual void SetValue(std::string key, boost::shared_ptr<ICanBeASetting> value);
		virtual void SetValue(std::string key, std::string value);
		virtual void SetValue(std::string key, const char* value);
		virtual void SetValue(std::string key, int value);
		virtual void SetValue(std::string key, unsigned int value);
		virtual void SetValue(std::string key, float value);
		virtual void SetValue(std::string key, double value);
		virtual void SetValue(std::string key, bool value);
		
		boost::shared_ptr<ICanBeASetting>& GetValue(std::string key) throw();

		bool HasValue(std::string key);
	};

}}


#endif  __BASECODE_SYSTEM_ISETTINGS_H__

