#include "Settings.h"

namespace basecode { namespace System {

	Settings::Settings(){}
	
	Settings::~Settings()
	{
		_settings.empty();
	}


	void Settings::SetValue(std::string key, boost::shared_ptr<ICanBeASetting> value)
	{
		if(_settings.find(key) != _settings.end())_settings.erase(key);
		_settings.insert(std::pair<std::string,boost::shared_ptr<ICanBeASetting>>(key,value));
	}

	void Settings::SetValue(std::string key, std::string value)
	{
		SetValue(key, boost::shared_ptr<ICanBeASetting>(new StringSettingValue(value)));
	}

	void Settings::SetValue(std::string key, const char * value)
	{
		SetValue(key, boost::shared_ptr<ICanBeASetting>(new StringSettingValue(value)));
	}

	void Settings::SetValue(std::string key, int value)
	{
		SetValue(key, boost::shared_ptr<ICanBeASetting>(new IntSettingValue(value)));
	}

	void Settings::SetValue(std::string key, unsigned int value)
	{
		SetValue(key, boost::shared_ptr<ICanBeASetting>(new UIntSettingValue(value)));
	}

	void Settings::SetValue(std::string key, float value)
	{
		SetValue(key, boost::shared_ptr<ICanBeASetting>(new FloatSettingValue(value)));
	}

	void Settings::SetValue(std::string key, double value)
	{
		SetValue(key, boost::shared_ptr<ICanBeASetting>(new DoubleSettingValue(value)));
	}

	void Settings::SetValue(std::string key, bool value)
	{
		SetValue(key, boost::shared_ptr<ICanBeASetting>(new BoolSettingValue(value)));
	}
	
	boost::shared_ptr<ICanBeASetting>& Settings::GetValue(std::string key) throw ()
	{
		if(_settings.find(key) != _settings.end()) return _settings[key];
		throw error_key_not_found;
	}

	bool Settings::HasValue(std::string key)
	{
		return(_settings.find(key) != _settings.end());
	}
}}