#ifndef __BASECODE_SYSTEM_SETTINGVALUE_H__
#define __BASECODE_SYSTEM_SETTINGVALUE_H__

#include <string>
//#include <typeinfo>
#include <boost/smart_ptr.hpp>

#include "ICanBeASetting.h"

namespace basecode { namespace System {

	class SettingValue {
	private:
		//Use a shared_ptr so we don't have to sweat cleanup
		boost::shared_ptr<ICanBeASetting> _value;
		//type_info _type;
	
	public:
		SettingValue(boost::shared_ptr<ICanBeASetting> value);
		virtual ~SettingValue();

		ICanBeASetting& GetValue();
	};

	///Wrapper for string value
	class StringSettingValue : public ICanBeASetting
	{
	private:
		std::string _value;
	public:
		StringSettingValue(std::string value);
		~StringSettingValue();

		operator std::string&();
	};

	///Wrapper for int value
	class IntSettingValue : public ICanBeASetting
	{
	private:
		int _value;
	public:
		IntSettingValue(int value);
		~IntSettingValue();

		operator int&();
	};

	///Wrapper for int value
	class UIntSettingValue : public ICanBeASetting
	{
	private:
		unsigned int _value;
	public:
		UIntSettingValue(unsigned int value);
		~UIntSettingValue();

		operator unsigned int&();
	};

	///Wrapper for float value
	class FloatSettingValue : public ICanBeASetting
	{
	private:
		float _value;
	public:
		FloatSettingValue(float value);
		~FloatSettingValue();

		operator float&();
	};

	///Wrapper for double value
	class DoubleSettingValue : public ICanBeASetting
	{
	private:
		double _value;
	public:
		DoubleSettingValue(double value);
		~DoubleSettingValue();

		operator double&();
	};

	///Wrapper for bool value
	class BoolSettingValue : public ICanBeASetting
	{
	private:
		bool _value;
	public:
		BoolSettingValue(bool value);
		~BoolSettingValue();

		operator bool&();
	};

}}

#endif  __BASECODE_SYSTEM_SETTINGVALUE_H__