#include "SettingValue.h"

namespace basecode { namespace System {

	SettingValue::SettingValue(boost::shared_ptr<ICanBeASetting> value)
	{
		_value = value;
	}

	SettingValue::~SettingValue()
	{
		_value.reset();//make sure we give up our reference to the data
	}

	StringSettingValue::StringSettingValue(std::string value)
	{
		_value = value;
	}

	StringSettingValue::~StringSettingValue()
	{
		_value = "";
	}

	StringSettingValue::operator std::string&()
	{
		return _value;
	}

	IntSettingValue::IntSettingValue(int value)
	{
		_value = value;
	}

	IntSettingValue::~IntSettingValue()
	{
		_value = 0;
	}

	IntSettingValue::operator int&()
	{
		return _value;
	}

	UIntSettingValue::UIntSettingValue(unsigned int value)
	{
		_value = value;
	}

	UIntSettingValue::~UIntSettingValue()
	{
		_value = 0;
	}

	UIntSettingValue::operator unsigned int&()
	{
		return _value;
	}

	FloatSettingValue::FloatSettingValue(float value)
	{
		_value = value;
	}

	FloatSettingValue::~FloatSettingValue()
	{
		_value = 0;
	}

	FloatSettingValue::operator float&()
	{
		return _value;
	}

	DoubleSettingValue::DoubleSettingValue(double value)
	{
		_value = value;
	}

	DoubleSettingValue::~DoubleSettingValue()
	{
		_value = 0;
	}

	DoubleSettingValue::operator double&()
	{
		return _value;
	}

	BoolSettingValue::BoolSettingValue(bool value)
	{
		_value = value;
	}

	BoolSettingValue::~BoolSettingValue()
	{
		_value = false;
	}

	BoolSettingValue::operator bool&()
	{
		return _value;
	}
}}