#include <iostream>
#include <boost/shared_ptr.hpp>

#include "Settings.h"
#include "SettingsGetValueT.h"
//#include "Error.h"
#include "TalonFiveGameInputMapping.h"
#include "Resolver.h" 
//#include "IResolveRegistry.h"
#include "TalonFiveGameRegistry.h"
#include "TalonFiveConstants.h"
#include "TalonFiveMenuInputMapping.h"
#include "IModule.h"
#include "TalonFiveModule.h"
#include "ModuleManager.h"

#include "GlfwConstants.h"

#include "Game/Kernel.h"
#include "Game/KernelFactory.h"

void setupTalonFive()
{
	using namespace basecode::System;
	using namespace basecode::Input;
	using namespace basecode::Game;
	using namespace TalonFive;

	Resolver::AddRegistry(new TalonFive::GameRegistry());
	
	SET_SETTING(Glfw::resx, 1500);
	SET_SETTING(Glfw::resy, 900);
	SET_SETTING(Glfw::windowed, true);
	SET_SETTING(Glfw::windowtitle, "Prototype");
	SET_SETTING(TalonFive::exit, false);
	SET_SETTING(TalonFive::reset, false);

	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Exit, raw_keyboard_esc);
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Reset, raw_keyboard_f10);

	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Up, raw_keyboard_up);
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Down, raw_keyboard_down);
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Left, raw_keyboard_left);
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Right, raw_keyboard_right);
	
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Mouse_LB, raw_mouse_button_left);
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Mouse_RB, raw_mouse_button_right);
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Mouse_MB, raw_mouse_button_middle);
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Mouse_X, raw_mouse_axis_x);
	Resolve<GameInputMapping>()->AddMapping(TalonFive::Input_Mouse_Y, raw_mouse_axis_y);

	MAP_MENU(MenuInputMapping::Up, raw_keyboard_up);
	MAP_MENU(MenuInputMapping::Down, raw_keyboard_down);
	MAP_MENU(MenuInputMapping::Select, raw_keyboard_enter);
	MAP_MENU(MenuInputMapping::Back, raw_keyboard_esc);
	MAP_MENU(MenuInputMapping::Back, raw_keyboard_backspace);
}

int main()
{
	using namespace basecode::System;
	using namespace basecode::Input;
	using namespace basecode::Game;
	using namespace TalonFive;
	
	setupTalonFive();

	ModuleManager * moduleManager = Resolve<ModuleManager>();

	moduleManager->AddModule(new TalonFive::Module());

	Kernel * kernel = KernelFactory::CreateKernel();


	//TODO: put this loop into the kernel or something
	while(!GET_SETTING(TalonFive::exit,bool))
	{
		//moduleManager->Init();
		kernel->Init();

		while(!GET_SETTING(TalonFive::exit,bool) && !GET_SETTING(TalonFive::reset,bool))
		{
			//moduleManager->Run();
			kernel->Run();
		}
		
		//moduleManager->Shutdown();
		kernel->Shutdown();

		SET_SETTING(TalonFive::reset, false);
	}
	return 0;
}
