#ifndef __BASECODE_SYSTEM_RESOLVER_H__
#define __BASECODE_SYSTEM_RESOLVER_H__

#include <typeinfo>
#include <boost/unordered_map.hpp>
#include <boost/function.hpp>

#include "Error.h"
#include "IResolvable.h"
#include "IResolveRegistry.h"

namespace basecode { namespace System {

	class Resolver {

	private:

		boost::unordered_map<size_t, IResolvable *> lookup;

		boost::unordered_map<size_t, IResolvable * (*)()> createLazyFunc;

		boost::unordered_map<size_t, IResolvable * (*)()> createInstanceFunc;

		static Resolver * instance;

		static Resolver * GetInstance();


	public:

		static error_t Register(const std::type_info& registerType, IResolvable * object);

		static error_t RegisterLazy(const std::type_info& registerType, IResolvable * (*createObject)());

		static error_t RegisterInstancePer(const std::type_info& registerType, IResolvable * (*createObject)());

		static void Deregister(const std::type_info& registerType);

		static IResolvable * Resolve(const std::type_info& objectType) throw();

		static void AddRegistry(IResolveRegistry * registry);

	};
	
	template <class resolveType>
	class RegisterInstanceInfo{
		IResolvable * (*_createObject)();
	public:
		RegisterInstanceInfo(IResolvable * (*createObject)())
		{
			_createObject= createObject;
		}
		
		error_t Shared()
		{
			return Resolver::Register(typeid(resolveType), _createObject());
		}

		error_t LazyShared()
		{
			return Resolver::RegisterLazy(typeid(resolveType), _createObject);
		}

		error_t InstancePerResolve()
		{
			return Resolver::RegisterInstancePer(typeid(resolveType), _createObject);
		}
		
	};

	template <class resolveType>
	RegisterInstanceInfo<resolveType> Register( IResolvable * (*createObject)() )
	{
		return RegisterInstanceInfo<resolveType>(createObject);
	}

	template <class resolveType> 
	void Deregister()
	{
		return Resolver::Deregister(typeid(resolveType));
	}

	template <class resolveType>
	resolveType * Resolve()
	{
		return dynamic_cast<resolveType*>(Resolver::Resolve(typeid(resolveType)));
	}

}}

#endif  __BASECODE_SYSTEM_RESOLVER_H__