#include "PTimer.h"

namespace basecode { namespace PTimer {

	PTimer::PTimer()
	{
		pclock = 0;
		min_interval = .01f;
		max_interval = .05f;
	}

	void PTimer::init(Timer::Timer* t)
	{
		init(t, .01f, .05f);
	}

	void PTimer::init(Timer::Timer* t, float min, float max)
	{
		timer = t;
		min_interval = min;
		max_interval = max;
		pclock = 0;
	}

	bool PTimer::ready()
	{
		double t = timer->time();
		float delta = float(t - pclock);

		if (delta < min_interval) return false;
		if (delta > max_interval) delta = max_interval;

		pclock = t - delta + min_interval;

		return true;
	}

	void PTimer::reset()
	{
		pclock = timer->time();
	}

}}