#include <boost/foreach.hpp>

#include "ModuleManager.h"
#include "Resolver.h"

namespace basecode { namespace Game {

	void ModuleManager::AddModule(IModule * module)
	{
		_modules.push_back(module);
		_modulesReverse.push_front(module);
	}

	void ModuleManager::RemoveModule(IModule * module)
	{
		_modules.remove(module);
		_modulesReverse.remove(module);
	}

	void ModuleManager::Init()
	{
		BOOST_FOREACH(IModule * module, _modules) module->Init();
	}
	
	void ModuleManager::HandleInput(Input::InputObject * inputObject)
	{
		BOOST_FOREACH(IModule * module, _modulesReverse) module->HandleInput(*inputObject);
	}

	void ModuleManager::RunLogic()
	{
		//Run Game Logic
		BOOST_FOREACH(IModule * module, _modules) module->Run();
	}

	void ModuleManager::Render()
	{
		//Render
		BOOST_FOREACH(IModule * module, _modules) module->Render();		
	}

	void ModuleManager::Shutdown()
	{
		BOOST_FOREACH(IModule * module, _modulesReverse) module->Shutdown();
	}
}}