#ifndef __BASECODE_INPUT_INPUTOBJECT_H__
#define __BASECODE_INPUT_INPUTOBJECT_H__

#include <map>
#include <list>

#include "RawInputCode.h"
#include "IResolvable.h"

namespace basecode { namespace Input {
	
	//enum InputButtonState
	//{
	//	button_just_up = 0x0,
	//	button_is_down = 0x1,
	//	button_just_down = 0x3,
	//};

	class InputObject : public basecode::System::IResolvable
	{
	private:

		//std::map<RawInputCode, InputButtonState> _codes;
		//std::map<RawInputCode, float> _axes;

		unsigned char _joybuttons[16];
		float _joyaxes[8];
		int _mousex;
		int _mousey;
		int _mousewheel;
		int _numJoystick;

	public:
		InputObject(int numJoystick);

		void UpdateInput();

		///Return if a key is pressed
		bool IsKeyDown(RawInputCode code);
		
		/////Return if a key was just pressed
		//bool IsKeyJustDown(RawInputCode code);

		///Return if a key is released
		bool IsKeyUp(RawInputCode code);

		///Return if a key was just released
		//bool IsKeyJustUp(RawInputCode code);

		/////Return whether an axis exists or has already been handled
		//bool HasAxis(RawInputCode code);

		///Return the value of an axis
		float GetAxis(RawInputCode code);

		/////Mark an input code as handled
		//void Handle(RawInputCode code);
	};
}}

#endif __BASECODE_INPUT_INPUTOBJECT_H__