#ifndef __BASECODE_NETWORKED_MODULE_H__
#define __BASECODE_NETWORKED_MODULE_H__

#include "IModule.h"
#include "IResolvable.h"
#include "Game/IGameState.h"

namespace basecode { 
	class INetworkedModule : public IModule {

	public:

		///No run-specific data should be cleaned up in here, that should all be in Shutdown()
		virtual ~INetworkedModule();

		///Handle a network sync, occurs before handleinput (todo: verify)
		virtual void NetworkSync(Game::IGameState & game_state)=0;

		///Interpolate the data to match data from the last network sync
		///between network sync data packets
		virtual void InterpolateData()=0;
	};
}

#endif  __BASECODE_NETWORKED_MODULE_H__
