#ifndef __BASECODE_I_MODULE_H__
#define __BASECODE_I_MODULE_H__

#include "InputObject.h"
#include "IResolvable.h"

namespace basecode { 
	class IModule : public System::IResolvable {

	public:
		///No run-specific data should be in here, that should all be in Init()
		//IModule();

		///No run-specific data should be cleaned up in here, that should all be in Shutdown()
		virtual ~IModule();

		///Module initialization
		virtual void Init()=0;

		///Process the input, be sure to mark used input data as "handled" (ie to avoid a menu click to be also used as an in-game click)
		virtual void HandleInput(Input::InputObject & object)=0;

		///Run module logic etc
		virtual void Run()=0;

		///Render visuals
		virtual void Render()=0;

		///Module shutdown
		virtual void Shutdown()=0;
	};
}

#endif  __BASECODE_I_MODULE_H__