#ifndef __BASECODE_HULL_H__
#define __BASECODE_HULL_H__

#include "Math.h"
#include "Model.h"
#include <vector>

namespace basecode { 

	using namespace basecode::Math;

	class HullPlane
	{
	public:
		std::vector<vec3f> vertices;
		vec3f normal;
	};

	class Hull
	{
	public:
		std::vector<HullPlane> planes;
		std::vector<vec3f> vertices;
		std::vector<vec2i> edges;

		int hpoint;
		int hface;
		int dface;
		int hedge;
		float radius;
		float minRadius;
		float surfaceArea;

		unsigned int vertexBuffer;
		unsigned int colorBuffer;

		Hull();
		void buildBuffers();
		void color(float r, float g, float b);
		void importModel(basecode::Model model);
		void addPlane(vec3f p1, vec3f p2, vec3f p3);
	};

}

#endif __BASECODE_HULL_H__