#include "Hull.h"
#include "Model.h"

namespace basecode {

	Hull::Hull()
	{
		hpoint = -1;
		hface = -1;
		dface = -1;
		hedge = -1;
		radius = 0;
		minRadius = 0;
		surfaceArea = 0;

		glGenBuffers(1, &vertexBuffer);
		glGenBuffers(1, &colorBuffer);
        
	}

	void Hull::importModel(basecode::Model model)
	{
		vertices = model.vertices;
		edges = model.edge_list();
		planes.clear();

		for (unsigned int f = 0; f < model.faces.size(); f++)
		{
			addPlane(model.vertices[model.faces[f].point_id[0]], model.vertices[model.faces[f].point_id[1]], model.vertices[model.faces[f].point_id[2]]);
		}

		radius = model.radius();
		minRadius = model.minRadius();

		buildBuffers();
	}

	void Hull::addPlane(vec3f p1, vec3f p2, vec3f p3)
	{
		HullPlane plane;

		plane.vertices.push_back(p1);
		plane.vertices.push_back(p2);
		plane.vertices.push_back(p3);

		plane.normal = (p2 - p1).cross(p3 - p1);
		plane.normal.normalize();

		planes.push_back(plane);
	}

	void Hull::buildBuffers()
	{
		std::vector<float> vtx;
		
		for (unsigned int f = 0; f < planes.size(); f++)
			for (unsigned int i = 0; i < 3; i++)
			{
				vtx.push_back(planes[f].vertices[i].x);
				vtx.push_back(planes[f].vertices[i].y);
				vtx.push_back(planes[f].vertices[i].z);
			}

		glBindBuffer(GL_ARRAY_BUFFER, vertexBuffer);
		glBufferData(GL_ARRAY_BUFFER, vtx.size() * sizeof(float), &vtx[0], GL_STATIC_DRAW);	
	}

	void Hull::color(float r, float g, float b)
	{
		std::vector<float> clr;
		float ratio;
		
		for (unsigned int f = 0; f < planes.size(); f++)
		{
			ratio = .5f + .5f * planes[f].normal.dot(0, 1, 0);

			for (unsigned int i = 0; i < 3; i++)
			{
				clr.push_back(r * ratio);
				clr.push_back(g * ratio);
				clr.push_back(b * ratio);
			}
		}

		glBindBuffer(GL_ARRAY_BUFFER, colorBuffer);
		glBufferData(GL_ARRAY_BUFFER, clr.size() * sizeof(float), &clr[0], GL_STATIC_DRAW);	
	}
}