#ifndef __BASECODE_GAME_MODULE_SUBPROCESSES_H__
#define __BASECODE_GAME_MODULE_SUBPROCESSES_H__

#include "IModuleInitSubProcess.h"
#include "IInputSubProcess.h"
#include "IRunLogicSubProcess.h"
#include "IRenderSubProcess.h"
#include "IModuleShutdownSubProcess.h"


#include "../ModuleManager.h"

namespace basecode { namespace Game {

	class ModuleInitSubProcess : public IModuleInitSubProcess
	{
	private:
		
		ModuleManager * _moduleManager;

	public:
		
		ModuleInitSubProcess(ModuleManager * moduleManager);
		virtual ~ModuleInitSubProcess();

		virtual void Run();

	};

	class ModuleHandleInputSubProcess : public IInputSubProcess
	{
	private:
		
		ModuleManager * _moduleManager;

	public:

		ModuleHandleInputSubProcess(ModuleManager * moduleManager);
		virtual ~ModuleHandleInputSubProcess();

		virtual void Run();

	};

	class ModuleRunLogicSubProcess : public IRunLogicSubProcess
	{
	private:
		
		ModuleManager * _moduleManager;

	public:
		
		ModuleRunLogicSubProcess(ModuleManager * moduleManager);
		virtual ~ModuleRunLogicSubProcess();

		virtual void Run();

	};

	class ModuleRenderSubProcess : public IRenderSubProcess
	{
	private:

		ModuleManager * _moduleManager;

	public:
		
		ModuleRenderSubProcess(ModuleManager * moduleManager);
		virtual ~ModuleRenderSubProcess();

		virtual void Run();
	};

	class ModuleShutdownSubProcess : public IModuleShutdownSubProcess
	{
	private:
		ModuleManager * _moduleManager;

	public:
		
		ModuleShutdownSubProcess(ModuleManager * moduleManager);
		virtual ~ModuleShutdownSubProcess();

		virtual void Run();
	};

}}


#endif  __BASECODE_GAME_MODULE_SUBPROCESSES_H__
