#include "ModuleSubProcessStack.h"

#include "../InputObject.h"
#include "InputObject.h"
#include "InputMapping.h"
#include "../Resolver.h"

namespace basecode { namespace Game {

	ModuleInitSubProcess::ModuleInitSubProcess(ModuleManager * moduleManager)
	{
		_moduleManager = moduleManager;
	}

	ModuleInitSubProcess::~ModuleInitSubProcess(){}

	void ModuleInitSubProcess::Run()
	{
		_moduleManager->Init();
	}


	ModuleHandleInputSubProcess::ModuleHandleInputSubProcess(ModuleManager * moduleManager)
	{
		_moduleManager = moduleManager;
	}

	ModuleHandleInputSubProcess::~ModuleHandleInputSubProcess(){}

	void ModuleHandleInputSubProcess::Run()
	{
		Input::InputObject * inputObject = System::Resolve<Input::InputObject>();
		//InputMapping * mapping = System::Resolve<InputMapping>();
		//InputObject gameInputObject = InputObject(inputObject,mapping);
		_moduleManager->HandleInput(inputObject);
	}


	ModuleRunLogicSubProcess::ModuleRunLogicSubProcess(ModuleManager * moduleManager)
	{
		_moduleManager = moduleManager;
	}

	ModuleRunLogicSubProcess::~ModuleRunLogicSubProcess(){}

	void ModuleRunLogicSubProcess::Run()
	{
		_moduleManager->RunLogic();
	}


	ModuleRenderSubProcess::ModuleRenderSubProcess(ModuleManager * moduleManager)
	{
		_moduleManager = moduleManager;
	}

	ModuleRenderSubProcess::~ModuleRenderSubProcess(){}

	void ModuleRenderSubProcess::Run()
	{
		_moduleManager->Render();
	}


	ModuleShutdownSubProcess::ModuleShutdownSubProcess(ModuleManager * moduleManager)
	{
		_moduleManager = moduleManager;
	}

	ModuleShutdownSubProcess::~ModuleShutdownSubProcess(){}

	void ModuleShutdownSubProcess::Run()
	{
		_moduleManager->Shutdown();
	}

}}
