#ifndef __BASECODE_GAME_KERNEL_H__
#define __BASECODE_GAME_KERNEL_H__

#include <utility>
#include <typeinfo>
#include <list>
#include <cstring>

#include "ISubProcess.h"


#include "IInitSubProcess.h"
#include "IShutdownSubProcess.h"

namespace basecode { namespace Game {


	class Kernel
	{
	private:
		
		std::list <std::pair<size_t, IInitSubProcess*> > _initSubProcessList;
		std::list <std::pair<size_t, ISubProcess*> > _subProcessList;
		std::list <std::pair<size_t, IShutdownSubProcess*> > _shutdownSubProcessList;
		

	public:
		
		template<class T>
		Kernel& AddSubProcess(T * subprocess)
		{
			_subProcessList.push_back(std::pair<size_t, ISubProcess*>(typeid(T).hash_code(), subprocess));
			return *this;
		}

		template<class T>
		Kernel& AddInitSubProcess(T * subprocess)
		{
			_initSubProcessList.push_back(std::pair<size_t, IInitSubProcess*>(typeid(T).hash_code(), subprocess));
			return *this;
		}

		template<class T>
		Kernel& AddShutdownSubProcess(T * subprocess)
		{
			_shutdownSubProcessList.push_back(std::pair<size_t, IShutdownSubProcess*>(typeid(T).hash_code(), subprocess));
			return *this;
		}

		void Init();
		void Run();
		void Shutdown();
	};

}}


#endif  __BASECODE_GAME_KERNEL_H__