#ifndef __BASECODE_GAME_INPUTOBJECT_H__
#define __BASECODE_GAME_INPUTOBJECT_H__

#include "../InputObject.h"
#include "InputMapping.h"
#include "../Error.h"
#include "InputConverter.h"

namespace basecode { namespace Game {
	class InputObject {
	private:
		Input::InputObject * _inputObject;
		InputMapping * _inputMapping;
		//std::map<Input::RawInputCode, Input::InputButtonState> _codes;
		//std::map<Input::RawInputCode, float> _axes;
	public:
		InputObject(Input::InputObject * inputObject, InputMapping * inputMapping);

		///Return if a key is pressed
		bool IsKeyDown(int code);
		
		/////Return if a key was just pressed
		//bool IsKeyJustDown(int code);

		///Return if a key is released
		bool IsKeyUp(int code);

		/////Return if a key was just released
		//bool IsKeyJustUp(int code);

		/////Return whether an axis exists or has already been handled
		//bool HasAxis(int code);

		///Return the value of an axis
		float GetAxis(int code);// throw(...);

		/////Mark an input code as handled
		//void Handle(int code);

	};
}}

#endif  __BASECODE_GAME_INPUTOBJECT_H__
