#include <boost/foreach.hpp>
#include "InputObject.h"

namespace basecode { namespace Game {

		InputObject::InputObject(Input::InputObject * inputObject, InputMapping * inputMapping)
		{
			_inputObject = inputObject;
			_inputMapping = inputMapping;
		}

		///Return if a key is pressed
		bool InputObject::IsKeyDown(int code)
		{
			BOOST_FOREACH(Input::RawInputCode rawCode , _inputMapping->GetMappings(code))
			{
				if(_inputObject->IsKeyDown(rawCode)) return true;
			}
			return false;
		}
		
		/////Return if a key was just pressed
		//bool InputObject::IsKeyJustDown(int code)
		//{
		//	BOOST_FOREACH(Input::RawInputCode rawCode , _inputMapping->GetMappings(code))
		//	{
		//		if(_inputObject->IsKeyJustDown(rawCode)) return true;
		//	}
		//	return false;
		//}

		///Return if a key is released
		bool InputObject::IsKeyUp(int code)
		{
			BOOST_FOREACH(Input::RawInputCode rawCode , _inputMapping->GetMappings(code))
			{
				if(_inputObject->IsKeyUp(rawCode)) return true;
			}
			return false;
		}

		/////Return if a key was just released
		//bool InputObject::IsKeyJustUp(int code)
		//{
		//	BOOST_FOREACH(Input::RawInputCode rawCode , _inputMapping->GetMappings(code))
		//	{
		//		if(_inputObject->IsKeyJustUp(rawCode)) return true;
		//	}
		//	return false;
		//}

		/////Return whether an axis exists or has already been handled
		//bool InputObject::HasAxis(int code)
		//{
		//	//Its a bad idea to define multiple mappings to axes, you have no idea
		//	//what you'll get :D
		//	BOOST_FOREACH(Input::RawInputCode rawCode , _inputMapping->GetMappings(code))
		//	{
		//		if(_inputObject->HasAxis(rawCode)) return true;
		//	}
		//	return false;
		//}

		///Return the value of an axis
		float InputObject::GetAxis(int code) 
		{
			//Its a bad idea to define multiple mappings to axes, you have no idea
			//what you'll get :D
			BOOST_FOREACH(Input::RawInputCode rawCode , _inputMapping->GetMappings(code))
			{
				return _inputObject->GetAxis(rawCode);
			}
			throw error_not_defined;
		}

		/////Mark an input code as handled
		//void InputObject::Handle(int code)
		//{
		//	BOOST_FOREACH(Input::RawInputCode rawCode , _inputMapping->GetMappings(code))
		//	{
		//		_inputObject->Handle(rawCode);
		//	}
		//}
}}