#include "InputConverter.h"
#include "InputObject.h"
#include <cmath>
#ifndef signof
inline float signof(float a) { return (a == 0) ? 0.0f : (a<0 ? -1.0f : 1.0f); }
#endif

namespace basecode { namespace Game {

	InputConverter::InputConverter(){}

		InputConverter InputConverter::DigitalizeAxis(Input::RawInputCode axis, float threshold)
		{
			InputConverter r;
			r._code = axis;
			r._convert_to_axis=false;
			r._floatValue = threshold;
			return r;
		}

		InputConverter InputConverter::AnalogizeButton(Input::RawInputCode button, float multiplier)
		{
			InputConverter r;
			r._code = button;
			r._convert_to_axis=true;
			r._floatValue = multiplier;
			return r;
		}

		bool InputConverter::GetAxisTriggered(Input::InputObject & inputObject)
		{
			float axisValue = inputObject.GetAxis(_code);
			
			if( signof(axisValue) == signof(_floatValue) && std::abs(axisValue) > std::abs(_floatValue))
			{
				_wasLastAxisTriggeredTrue = true;
				return true;
			}else{
				_wasLastAxisTriggeredTrue = false;
				return false;
			}
		}

		bool InputConverter::GetAxisJustTriggered(Input::InputObject & inputObject)
		{
			return false;
		}

		bool InputConverter::GetAxisUnTriggered(Input::InputObject & inputObject)
		{
			return false;
		}

		bool InputConverter::GetAxisJustUnTriggered(Input::InputObject & inputObject)
		{
			return false;
		}

		float InputConverter::GetButtonAxis(Input::InputObject & inputObject)
		{
			return 0.0f;
		}
}}