#ifndef __BASECODE_I_GAME_OBJECT_H__
#define __BASECODE_I_GAME_OBJECT_H__

#include "../Math.h"
#include "../Physics.h"
#include "../IRenderObject.h"

namespace basecode { namespace Game {
	class IGameObject: public basecode::IRenderObject {

	public:
		
		virtual ~IGameObject();

		virtual void collision(unsigned int obj, basecode::Math::vec3f pnt)=0;
		virtual bool garbage()=0;
		virtual Physics::PhysicsObject* physics()=0;
		virtual void update(float interval)=0;
		
	};
}}

#endif  __BASECODE_I_GAME_OBJECT_H__
