#include "Fps.h"

namespace basecode { namespace Fps {

	Fps::Fps()
	{
		curr = 0;
		ticks = 0;
		cycles = 0;
		avg = 0;
		updateInterval = 1;
		updateMethod = BC_FPS_UPDATE_SECONDS;
	}

	void Fps::reset()
	{
		curr = 0;
		ticks = 0;
		cycles = 0;
		avg = 0;
	}

	float Fps::value()
	{
		return curr;
	}

	void Fps::update()
	{
		float tDelta;

		cycles++;
		
		if (ticks == 0) ticks = (float)glfwGetTime();

		if (updateMethod == BC_FPS_UPDATE_FRAMES)
		{
			if (cycles >= updateInterval)
			{
				curr = 1 / float((glfwGetTime() - ticks) / (float)cycles);
				ticks = (float)glfwGetTime();
				cycles = 0;

				avg += (curr - avg) * .1f;
			}
		}

		if (updateMethod == BC_FPS_UPDATE_SECONDS)
		{
			tDelta = (float)glfwGetTime() - ticks;
			if (tDelta >= updateInterval)
			{
				curr = cycles / updateInterval;
				cycles = 0;
				ticks = (float)glfwGetTime() + tDelta - updateInterval;
				

				avg += (curr - avg) * .1f;
			}
		}
	}

	void Fps::onFrames(unsigned int f)
	{
		cycles = 0;
		updateInterval = (float)f;
		updateMethod = BC_FPS_UPDATE_FRAMES;
	}

	void Fps::onSeconds(float s)
	{
		ticks = 0;
		updateInterval = s;
		updateMethod = BC_FPS_UPDATE_SECONDS;
	}
}}