#ifndef __BASECODE_ERROR_H__
#define __BASECODE_ERROR_H__

namespace basecode {



	enum Error
	{
		///No error here
		error_none = 0,
		///Errors resulting from a missing file
		error_file_not_found = 0x80,
		///Errors resulting from the infamous null case
		error_null_reference = 0x100,
		///Errors indicating that a map/set does not contain a value for a given key
		error_key_not_found,
		///Errors indicating that a resolve failed
		error_could_not_resolve_type,
		///Errors indicating that something expected is not defined
		error_not_defined,
		///Errors resulting from trying to duplicate or re-define something that cannot be redefind
		error_already_defined = 0x120,
		///Reserved for the worst of errors, use with caution
		error_monkeys_ate_the_banana = 0xFECE5

	};

}

#define error_t basecode::Error

#endif __BASECODE_ERROR_H__