// Program:  Color.h - Color Class
// Language: C++
// Author:   Daniel Kennedy (Syn9), Quinton Roberts (Eclipzer)
//
// Copyright (c) 2009-2010
// ____________________________________________________________________________
#ifndef INC_COLOR_H
#define INC_COLOR_H

#include <cstring>
#include <string>
#include <sstream>
#include <GL/glfw.h>
#include <boost/archive/text_oarchive.hpp>

namespace basecode
{
	class Color
	{
		friend class boost::serialization::access;
		template<class Archive>
		void serialize(Archive & ar, const unsigned int version)
		{
			ar & r;
			ar & g;
			ar & b;
			ar & a;
		}
	public:
		float	r;
		float	g;
		float	b;
		float	a;

		Color(float red, float green, float blue, float alpha);
		Color(float red, float green, float blue);
		Color();

		const char* c_str();
		void glColor3f();
		void glColor4f();
		void set(float rgb);
		void set(float red, float green, float blue, float alpha);
		void set(float red, float green, float blue);
		void scale(float s);

		bool operator==(const Color &rhs);
		Color& operator*=(const float &rhs);
		Color operator*(const float &rhs);

	private:
		void init(float r0, float g0, float b0, float a0);
	};
}

#endif
