// Program:  Color.cpp - Color Class
// Language: C++
// Author:   Daniel Kennedy (Syn9), Quinton Roberts (Eclipzer)
//
// Copyright (c) 2009-2010
// ____________________________________________________________________________
#include "Color.h"

namespace basecode
{
	Color::Color(float red, float green, float blue, float alpha)
	{
		init(red, green, blue, alpha);
	}

	Color::Color(float red, float green, float blue)
	{
		init(red, green, blue, 1);
	}

	Color::Color()
	{
		init(0, 0, 0, 1);
	}

	const char* Color::c_str()
	{
		std::stringstream ss;
		ss << "Color<" << r << ", " << g << ", " << b << ", " << a << ">";

		char* cstr = new char [ss.str().size()+1];
		std::strcpy (cstr, ss.str().c_str());
		
		return (const char*)cstr;
	}
	
	void Color::glColor3f()
	{
		::glColor3f(r, g, b);
	}

	void Color::glColor4f()
	{
		::glColor4f(r, g, b, a);
	}

	void Color::set(float rgb)
	{
		set(rgb, rgb, rgb, 1);
	}

	void Color::set(float red, float green, float blue, float alpha)
	{
		r = red;
		g = green;
		b = blue;
		a = alpha;
	}

	void Color::set(float red, float green, float blue)
	{
		set(red, green, blue, 1);
	}

	void Color::init(float r0, float g0, float b0, float a0)
	{
		r = r0;
		g = g0;
		b = b0;
		a = a0;
	}

	void Color::scale(float s)
	{
		r *= s;
		g *= s;
		b *= s;
	}

	bool Color::operator==(const Color &rhs)
	{
		if (r == rhs.r && g == rhs.g && b == rhs.b && a == rhs.a) return true;
		return false;
	}

	Color& Color::operator*=(const float &rhs)
	{
		scale(rhs);
		return *this;
	}

	Color Color::operator*(const float &rhs)
	{
		Color result = *this;
		result.scale(rhs);
		return result;
	}
	
}
